' I2CREAD and I2WRITE Commands
' 24LC128  EEPROM 
' Write to the first 16 locations of an external serial EEPROM
' Read first 16 locations back and send to serial out repeatedly
' Note: for EEPROMS with byte-sized address

        INCLUDE "modedefs.bas"          ' Include serial modes

SO      VAR     PORTC.6                       ' Define serial output pin
DPIN    VAR     PORTC.4                 ' I2C data pin
CPIN    VAR     PORTC.3                 ' I2C clock pin
B0      VAR     BYTE
B1      VAR     BYTE
B2      VAR     BYTE
DEFINE  OSC     10
        For B0 = 0 TO 15                ' Loop 16 times
                I2CWrite DPIN,CPIN,$A8,00,B0,[B0]  ' Write each location's address to itself
                Pause 10                ' Delay 10ms after each write
        Next B0

loop:   For B0 = 0 TO 15 STEP 2         ' Loop 8 times
                I2CRead DPIN,CPIN,$A8,00,B0,[B1,B2]        ' Read 2 locations in a row
                SerOut SO,T9600,[#B1," ",#B2," "]       ' Print 2 locations
                Pause 100
        Next B0

        SerOut SO,T9600,[10,13]            ' Print linefeed

        GoTo loop
